#  
#  WordCompounder --- Executable file name: GoMusubi
#  Copyright(C) 2021 Kaoru Sagara and Syugo Nakamura 
#  This software is released under any of the GPL (see the file GPL), the LGPL(see the file LGPL), or the BSD License (see the file BSD).

import re
import cchardet as chardet


def detect_encoding(filepath):
  """
  文字エンコード形式を判定する。

  Args:
      filepath (str): テキスト形式のファイルパス

  Returns:
      str: エンコード形式
  """
  with open(filepath, "rb") as f:
    byte_text = f.read()
    encoding = chardet.detect(byte_text)['encoding']

    if encoding == 'SHIFT_JIS':
      encoding = 'cp932'

    return encoding


def is_hiragana(text):
  """
  ひらがなかどうか判定する。

  Args:
      text (str): 対象テキスト

  Returns:
      bool: ひらがなの場合はTrue
  """
  re_hiragana = re.compile(r'^[あ-ん]+$')
  is_match = re_hiragana.fullmatch(text) 
  return is_match


def is_katakana(text):
  """
  カタカナかどうか判定する。

  Args:
      text (str): 対象テキスト

  Returns:
      bool: カタカナの場合はTrue
  """
  re_katakana = re.compile(r'[\u30A1-\u30F4]+')
  is_match = re_katakana.fullmatch(text)
  return is_match


def is_kanji(text):
  """
  漢字かどうか判定する。

  Args:
      text (str): 対象テキスト

  Returns:
      bool: 漢字の場合はTrue
  """
  re_kanji = re.compile(r'^[\u4E00-\u9FD0]+$')
  is_match = re_kanji.fullmatch(text)
  return is_match


def is_roman(text):
  """
  ローマ字かどうか判定する。

  Args:
      text (str): 対象テキスト

  Returns:
      bool: ローマ字の場合はTrue
  """
  re_roman = re.compile(r'^[a-zA-Z]+$')
  is_match = re_roman.fullmatch(text)
  return is_match


def is_numeric(text):
  """
  数字かどうか判定する。

  Args:
      text (str): 対象テキスト

  Returns:
      bool: ローマ字の場合はTrue
  """
  return text.isnumeric()

